/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.ftb.log.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AppUtils {
    public static String readString(InputStream stream) {
        Scanner scanner = new Scanner(stream).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    public static Document downloadXML(URL url) throws IOException, SAXException {
        return AppUtils.getXML(url.openStream());
    }

    public static Document getXML(InputStream stream) throws IOException, SAXException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            return docFactory.newDocumentBuilder().parse(stream);
        }
        catch (ParserConfigurationException ignored) {
            Logger.logError(ignored.getMessage(), ignored);
        }
        catch (UnknownHostException e) {
            Logger.logError(e.getMessage(), e);
        }
        return null;
    }

    public static void waitForLock(boolean b) {
        AppUtils.waitForLock(b, null);
    }

    public static void waitForLock(boolean b, String s) {
        while (!b) {
            try {
                Thread.sleep(100L);
                if (s == null) continue;
                Logger.logInfo("Waiting for " + s);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

